<?php
// Ruta del archivo que guarda el número de usuarios únicos
$archivo_visitas = 'visitas.txt';

// Si la cookie no está seteada, contamos como visita única
if (!isset($_COOKIE['revista_visitada'])) {
    // Leer el contador actual o iniciarlo en 0
    if (!file_exists($archivo_visitas)) {
        file_put_contents($archivo_visitas, 0);
    }

    $visitas = (int)file_get_contents($archivo_visitas);
    $visitas++;
    file_put_contents($archivo_visitas, $visitas);

    // Crear cookie que dura 30 días
    setcookie('revista_visitada', '1', time() + (30 * 24 * 60 * 60));
} else {
    // Si ya existe la cookie, solo leemos el número de visitas
    $visitas = (int)file_get_contents($archivo_visitas);
}

$total_paginas = 5;

$pagina_actual = isset($_GET['pagina']) ? intval($_GET['pagina']) : 1;
if ($pagina_actual < 1) $pagina_actual = 1;
if ($pagina_actual > $total_paginas) $pagina_actual = $total_paginas;

$nombre_archivo = sprintf("page_%02d.jpg", $pagina_actual);
$ruta_imagen = "pages/" . $nombre_archivo;
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Revista Digital</title>
    <style>
        body {
            margin: 0;
            background: #111;
            color: #fff;
            font-family: sans-serif;
            text-align: center;
            user-select: none;
        }
        .contenedor {
            max-width: 800px;
            margin: 20px auto;
            position: relative;
        }
        .pagina {
    opacity: 0;
    animation: slideIn 0.6s ease-in-out forwards;
    transform: translateX(-30px);
}

@keyframes slideIn {
    from {
        opacity: 0;
        transform: translateX(-50px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

        img {
            width: 100%;
            max-height: 90vh;
            object-fit: contain;
            pointer-events: none;
        }
        .botones {
            margin: 20px;
        }
        a.boton {
            color: white;
            padding: 10px 20px;
            background: #333;
            text-decoration: none;
            border-radius: 5px;
            margin: 0 10px;
        }
        a.boton:hover {
            background: #555;
        }
    </style>
    <script>
        document.addEventListener('keydown', function(e) {
            if (e.ctrlKey && ['p', 's', 'u'].includes(e.key.toLowerCase())) {
                e.preventDefault();
                alert('Función deshabilitada');
            }
        });
        document.addEventListener('contextmenu', function(e) {
            e.preventDefault();
        });
    </script>
</head>
<body>
    <div class="contenedor">
        <div class="pagina">
            <img src="<?php echo $ruta_imagen; ?>" alt="Página <?php echo $pagina_actual; ?>">
        </div>
        <div class="botones">
            <?php if ($pagina_actual > 1): ?>
                <a href="?pagina=<?php echo $pagina_actual - 1; ?>" class="boton">⬅ Anterior</a>
            <?php endif; ?>
            <?php if ($pagina_actual < $total_paginas): ?>
                <a href="?pagina=<?php echo $pagina_actual + 1; ?>" class="boton">Siguiente ➡</a>
            <?php endif; ?>
        </div>
        <p>Página <?php echo $pagina_actual; ?> de <?php echo $total_paginas; ?></p>
    </div>
</body>
</html>
